/* 
 *  SetDataRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.DataI;
import java.util.Map;

public class SetDataRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(SetDataRequest.class);
    private String newStrValue = null;
    private Map<String, String> map = null;
    private byte[] bytes = null;

    public SetDataRequest(String interactionID, String newValue) {
        super(LOG, interactionID);
        this.newStrValue = newValue;
    }

    public SetDataRequest(String interactionID, Map<String, String> newValue) {
        super(LOG, interactionID);
        this.map = newValue;
    }

    public SetDataRequest(String interactionID, byte[] newValue) {
        super(LOG, interactionID);
        this.bytes = newValue;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        String dataType = "NONE";
        LOG.trace(methodName + "+");

        DataI data = null;
        if (newStrValue != null) {
            data = DataI.create(newStrValue);
            dataType = "String";
        } else if (map != null) {
            data = DataI.create(map);
            dataType = "KVP";
        } else if (bytes != null) {
            data = DataI.create(bytes);
            dataType = "byte[]";
        }

        if (data != null) {
            LOG.info(methodName + "setting data of type:" + dataType);
            getInteraction().setData(data);
        }

        LOG.trace(methodName + "-");
        return null;
    }
}
